//AIM:To compute the responsivity,received optical power & the number of 
//photons received by a pn photodiode

//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Let us consider quantum efficiency of 50% at a wavelength of 0.9 micrometres 
//& mean photocurrent is 10^-6 Amp
n=50/100;//n=Quantum efficiency=50%(given)
lambda=0.9*(10^-6);
//(a): Responsivity
//Responsivity R is related to the quantum efficiency n as R=(n*e*lambda)/(h*e)
e=1.6*(10^-19);
h=6.6*(10^-34);
c=3*(10^8);
R=(n*e*lambda)/(h*c);
disp('AW^-1',R,'R=')

//(b):Received optical power:
//R=Ip/P0
Ip=10^-6;
P0=Ip/R;
disp('Watts',P0,'Received optical power (P0)=')

//No. of received photons :
E=(h*c)/(lambda);
disp('Watts',E,'E=')
//Optical power=No. of photons*Energy of a photon
NOP=P0/E;
disp('photons/sec',NOP,'Number of photons=')
